"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockNpmClient = void 0;
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const semver = __importStar(require("semver"));
/**
 * Mock implementation of INpmClient
 *
 * Useful for testing code that depends on INpmClient
 */
class MockNpmClient {
    constructor() {
        this.packages = {};
    }
    addPackageVersion({ packageName, version, tarballPath }) {
        if (!this.packages[packageName]) {
            this.packages[packageName] = {};
        }
        this.packages[packageName][version] = tarballPath;
    }
    getPackageVersions(packageName) {
        return __awaiter(this, void 0, void 0, function* () {
            return Object.keys(this.packages[packageName] || {});
        });
    }
    downloadPackage(_a) {
        return __awaiter(this, arguments, void 0, function* ({ packageName, downloadPath, version }) {
            if (!this.packages[packageName]) {
                throw new Error(`Package ${packageName} not found`);
            }
            const versionOrLatest = version || this.getLatestVersion(packageName);
            if (!versionOrLatest) {
                throw new Error(`No version found for package ${packageName}`);
            }
            const tarballPath = this.packages[packageName][versionOrLatest];
            if (!tarballPath) {
                throw new Error(`Version ${versionOrLatest} not found for package ${packageName}`);
            }
            const tarballFilename = path.basename(tarballPath);
            const destPath = path.join(downloadPath, tarballFilename);
            yield fs.copy(tarballPath, destPath);
            return destPath;
        });
    }
    getLatestVersion(packageName) {
        const versions = Object.keys(this.packages[packageName] || {});
        return semver.maxSatisfying(versions, '*');
    }
}
exports.MockNpmClient = MockNpmClient;
//# sourceMappingURL=MockNpmClient.js.map