import { DownloadPackageArgs, INpmClient } from './INpmClient';
/**
 * Mock implementation of INpmClient
 *
 * Useful for testing code that depends on INpmClient
 */
export declare class MockNpmClient implements INpmClient {
    private packages;
    addPackageVersion({ packageName, version, tarballPath }: {
        packageName: string;
        version: string;
        tarballPath: string;
    }): void;
    getPackageVersions(packageName: string): Promise<string[]>;
    downloadPackage({ packageName, downloadPath, version }: DownloadPackageArgs): Promise<string>;
    private getLatestVersion;
}
