"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseProvider = void 0;
const events_1 = require("events");
const eventsHelpers_1 = require("../Events/eventsHelpers");
const generator_1 = require("../Hash/generator");
const lockedDecorator_1 = require("../Lock/lockedDecorator");
const MAX_PENDING_TASKS = 100e3;
const LOCK_NAMESPACE = 'AMQP.ResponseProvider';
const RESPONSE_QUEUE_PREFIX = '__response.';
const RESPONSE_EVENT_NAME = 'response';
const ERROR_EVENT_NAME = 'error';
class ResponseProvider {
    constructor(amqplibConnection, decodeMessageBuffer) {
        this.amqplibConnection = amqplibConnection;
        this.decodeMessageBuffer = decodeMessageBuffer;
        this.eventEmitter = new events_1.EventEmitter();
        this.queueName = RESPONSE_QUEUE_PREFIX + '_' + (0, generator_1.generateUniqueHash)(8);
    }
    prepareResponse() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.ensureResponseConsumption();
            const correlationId = (0, generator_1.generateUniqueHash)();
            const eventName = this.getResponseEventName(correlationId);
            return {
                correlationId,
                queueName: this.queueName,
                promise: (0, eventsHelpers_1.waitForSuccessOrFailEvents)(this.eventEmitter, eventName, ERROR_EVENT_NAME),
            };
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.amqplibChannel) {
                if (this.consumerTag) {
                    yield this.amqplibChannel.cancel(this.consumerTag);
                    this.consumerTag = undefined;
                }
                yield this.amqplibChannel.close();
                this.amqplibChannel = undefined;
            }
        });
    }
    ensureResponseConsumption() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.consumerTag) {
                return this.consumerTag;
            }
            const amqplibChannel = yield this.getAmqplibResponseChannel(this.amqplibConnection, this.queueName);
            this.amqplibChannel = amqplibChannel;
            yield amqplibChannel.prefetch(100);
            const { consumerTag } = yield amqplibChannel.consume(this.queueName, (amqplibMessage) => __awaiter(this, void 0, void 0, function* () {
                amqplibChannel.ack(amqplibMessage);
                const message = this.decodeMessageBuffer(amqplibMessage.content);
                const eventName = this.getResponseEventName(amqplibMessage.properties.correlationId);
                this.eventEmitter.emit(eventName, message);
            }), {
                exclusive: true, // only one consumer should wait for response
            });
            this.consumerTag = consumerTag;
            return this.consumerTag;
        });
    }
    getAmqplibResponseChannel(amqplibConnection, queueName) {
        return __awaiter(this, void 0, void 0, function* () {
            const amqplibChannel = yield amqplibConnection.createChannel();
            yield this.assertResponseQueue(amqplibChannel, queueName);
            return amqplibChannel;
        });
    }
    assertResponseQueue(amqplibChannel, queueName) {
        return __awaiter(this, void 0, void 0, function* () {
            yield amqplibChannel.assertQueue(queueName, {
                durable: false,
                autoDelete: false,
                exclusive: true,
            });
        });
    }
    getResponseEventName(correlationId) {
        return `${RESPONSE_EVENT_NAME}.${correlationId}`;
    }
}
exports.ResponseProvider = ResponseProvider;
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_NAMESPACE, { maxPending: MAX_PENDING_TASKS }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ResponseProvider.prototype, "close", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_NAMESPACE, { maxPending: MAX_PENDING_TASKS }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ResponseProvider.prototype, "ensureResponseConsumption", null);
//# sourceMappingURL=ResponseProvider.js.map