"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWithLock = void 0;
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:AMQP:EventSourcing:Locked:withLock');
/**
 * Create a function waitLock that will use the deferredState for managing the deferred promises.
 *
 * It will wait for all previous promises with the same lock-keys to finish before executing the callback.
 * If the callback throws an error, all subsequent waiting promises with the same lock-keys will be rejected.
 */
const createWithLock = (deferredState) => (lockKeys, callback) => __awaiter(void 0, void 0, void 0, function* () {
    const previousPromises = deferredState.getPreviousPromises(lockKeys);
    const currentDeferred = deferredState.addDeferred(lockKeys);
    try {
        // Wait for all previous promises with the same lock-keys to finish
        yield Promise.all(previousPromises);
        try {
            debug('Starting locked callback', { lockKeys });
            yield callback();
            debug('Finished locked callback', { lockKeys });
            // Resolve the current deferred to allow the next promise to proceed
            currentDeferred.resolve();
        }
        catch (error) {
            debug('Error in locked callback', { lockKeys, error });
            // Reject all subsequent waiting promises with the same lock-keys in the same order
            currentDeferred.reject(new Error(`Previous promise with same lock-key failed, rejecting all subsequent waiting promises.`));
            // Because of call stack of JS, following error will be thrown and promise rejected first, before the above rejected promise
            throw error;
        }
    }
    finally {
        deferredState.removeDeferred(lockKeys, currentDeferred);
    }
});
exports.createWithLock = createWithLock;
//# sourceMappingURL=withLock.js.map