"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var events_1 = require("events");
var ISocket_1 = require("../ISocket");
var progressiveWait_1 = require("../../../Timer/progressiveWait");
var debug_1 = __importDefault(require("debug"));
var debug = (0, debug_1.default)('@signageos/lib:WebSocket:Client:WS:AutoReconnectingWSSocket');
var DEFAULT_INITIAL_RECONNECT_TIMEOUT = 1e3;
var DEFAULT_MAX_RECONNECT_TIMEOUT = 30e3;
var AutoReconnectingWSSocket = /** @class */ (function () {
    function AutoReconnectingWSSocket(createSocket, initialReconnectTimeout, maxReconnectTimeout) {
        if (initialReconnectTimeout === void 0) { initialReconnectTimeout = DEFAULT_INITIAL_RECONNECT_TIMEOUT; }
        if (maxReconnectTimeout === void 0) { maxReconnectTimeout = DEFAULT_MAX_RECONNECT_TIMEOUT; }
        this.createSocket = createSocket;
        this.closed = false;
        this.eventListeners = [];
        this.emitsQueue = [];
        this.progressiveWait = (0, progressiveWait_1.createProgressiveWait)(initialReconnectTimeout, 2, maxReconnectTimeout);
        this.internalEventEmitter = new events_1.EventEmitter();
        this.openNewSocket();
    }
    AutoReconnectingWSSocket.prototype.on = function (event, listener) {
        this.eventListeners.push({ type: 'on', event: event, listener: listener });
        this.socket.on(event, listener);
        debug('Number of listeners after on', this.eventListeners.length);
    };
    AutoReconnectingWSSocket.prototype.once = function (event, listener) {
        this.eventListeners.push({ type: 'once', event: event, listener: listener });
        this.registerOnceListenerOnCurrentSocket(event, listener);
        debug('Number of listeners after once', this.eventListeners.length);
    };
    AutoReconnectingWSSocket.prototype.emit = function (event, message, callback) {
        try {
            this.socket.emit(event, message, callback);
        }
        catch (error) {
            if (error instanceof ISocket_1.UndeliveredEmitError) {
                var emitData = { event: event, message: message, callback: callback };
                debug('Emit message failed', emitData, error);
                this.emitsQueue.push(emitData);
                debug('Number of emits in queue after fail', this.emitsQueue.length);
            }
            else {
                throw error;
            }
        }
    };
    AutoReconnectingWSSocket.prototype.removeListener = function (event, listener) {
        this.removeEventListenerFromList(event, listener);
        this.socket.removeListener(event, listener);
        debug('Number of listeners after remove', this.eventListeners.length);
    };
    AutoReconnectingWSSocket.prototype.removeAllListeners = function () {
        this.eventListeners = [];
        this.socket.removeAllListeners();
    };
    AutoReconnectingWSSocket.prototype.close = function () {
        this.closed = true;
        this.socket.close();
    };
    AutoReconnectingWSSocket.prototype.onConnected = function (callback) {
        this.internalEventEmitter.on('connected', callback);
    };
    AutoReconnectingWSSocket.prototype.onDisconnected = function (callback) {
        this.internalEventEmitter.on('disconnected', callback);
    };
    AutoReconnectingWSSocket.prototype.onError = function (callback) {
        this.internalEventEmitter.on('error', callback);
    };
    AutoReconnectingWSSocket.prototype.openNewSocket = function () {
        var _this = this;
        this.socket = this.createSocket(function () { return _this.onSocketConnected(); }, function () { return _this.onSocketDisconnected(); }, function (error) { return _this.internalEventEmitter.emit('error', error); });
        for (var _i = 0, _a = this.eventListeners; _i < _a.length; _i++) {
            var eventListener = _a[_i];
            if (eventListener.type === 'on') {
                this.socket.on(eventListener.event, eventListener.listener);
            }
            else {
                this.registerOnceListenerOnCurrentSocket(eventListener.event, eventListener.listener);
            }
        }
    };
    AutoReconnectingWSSocket.prototype.onSocketConnected = function () {
        debug('Internal socket connected');
        this.internalEventEmitter.emit('connected');
        this.progressiveWait.reset();
        // Try repeat only the current queue count from beggining (to prevent infinite loop)
        var repeatCount = this.emitsQueue.length;
        for (var i = 0; i < repeatCount; i++) {
            var emitData = this.emitsQueue.shift();
            if (emitData) {
                try {
                    this.emit(emitData.event, emitData.message, emitData.callback);
                }
                catch (error) {
                    debug('Could not repeat emit because of fatal failure', emitData, error);
                    console.error(error);
                }
            }
        }
        debug('Number of emits in queue after repeat', this.emitsQueue.length);
    };
    AutoReconnectingWSSocket.prototype.onSocketDisconnected = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        debug('Internal socket disconnected');
                        this.internalEventEmitter.emit('disconnected');
                        if (!!this.closed) return [3 /*break*/, 2];
                        this.socket.removeAllListeners();
                        return [4 /*yield*/, this.progressiveWait.wait()];
                    case 1:
                        _a.sent();
                        this.openNewSocket();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    AutoReconnectingWSSocket.prototype.registerOnceListenerOnCurrentSocket = function (event, listener) {
        var _this = this;
        this.socket.once(event, listener);
        this.socket.once(event, function () { return _this.removeEventListenerFromList(event, listener); });
    };
    AutoReconnectingWSSocket.prototype.removeEventListenerFromList = function (event, listener) {
        this.eventListeners = this.eventListeners.filter(function (eventListener) {
            return eventListener.event !== event || eventListener.listener !== listener;
        });
    };
    return AutoReconnectingWSSocket;
}());
exports.default = AutoReconnectingWSSocket;
//# sourceMappingURL=AutoReconnectingWSSocket.js.map