import IEvent, { IEventPayload } from '../AMQP/EventSourcing/IEvent';
import { IMetricsClient } from './MetricsClient';
declare const defaultOptions: {
    /**
     * Buckets for the event_duration_seconds_bucket metric.
     * Default buckets are [0.01, 0.05, 0.1, 0.5, 1, 2, 5, 10, 30, 60]
     */
    durationInSecondsHistogramBuckets: number[];
};
export interface EventProcessingMetricsExporterOptions extends Partial<typeof defaultOptions> {
}
export type EventProcessingMetrics = ReturnType<typeof createEventProcessingMetrics>;
export type EventProcessedData = {
    event: IEvent<IEventPayload>;
    stats: {
        /** Timestamp in milliseconds when consumption started */
        start: number;
        duration: number;
    };
};
export declare function createEventProcessingMetrics(metricsClient: IMetricsClient, options?: EventProcessingMetricsExporterOptions): {
    recordMetrics: ({ event, stats }: EventProcessedData) => void;
    eventCount: import("prom-client").Counter<"eventType">;
    eventDurationSum: import("prom-client").Counter<"eventType" | "phase">;
    eventDurationHistogram: import("prom-client").Histogram<string>;
};
export {};
