"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.logger = void 0;
exports.redirectAllLogsToLogger = redirectAllLogsToLogger;
var winston = __importStar(require("winston"));
var logger_1 = require("./logger");
var console_1 = require("./console");
var debug_1 = require("./debug");
var LogFormat;
(function (LogFormat) {
    LogFormat["JSON"] = "json";
    LogFormat["JSON_PRETTY"] = "json_pretty";
    LogFormat["Simple"] = "simple";
})(LogFormat || (LogFormat = {}));
var logLevel = process.env.LOG_LEVEL || 'debug';
var logFormat = process.env.LOG_FORMAT || LogFormat.JSON;
/**
 * If the log contains a nested Error, it will be formatted as an object with message and stack.
 *
 * Without this step, the output of serialization of the Error object is an empty object.
 * @see https://stackoverflow.com/questions/18391212/is-it-not-possible-to-stringify-an-error-using-json-stringify
 */
var formatNestedErrors = winston.format(function (info) {
    for (var _i = 0, _a = Object.entries(info); _i < _a.length; _i++) {
        var _b = _a[_i], key = _b[0], value = _b[1];
        if (value instanceof Error) {
            info[key] = Object.assign({}, value, {
                message: value.message,
                stack: value.stack,
            });
        }
    }
    return info;
});
var ensureJSONKeyOrder = winston.format(function (info) {
    var level = info.level, message = info.message, rest = __rest(info, ["level", "message"]);
    return __assign({ level: level, message: message }, rest);
});
var winstonFormatters = [
    // parses errors and adds stack trace, when error is passed as the first argument instead of message
    winston.format.errors({ stack: true }),
    // parses nested error objects and adds stack trace
    formatNestedErrors(),
];
switch (logFormat) {
    case LogFormat.JSON:
        winstonFormatters.push(ensureJSONKeyOrder(), // ensures that the keys in the JSON are always in the order we want
        winston.format.json({ deterministic: false }));
        break;
    case LogFormat.JSON_PRETTY:
        winstonFormatters.push(ensureJSONKeyOrder(), // ensures that the keys in the JSON are always in the order we want
        winston.format.json(), winston.format.prettyPrint({ colorize: true }));
        break;
    case LogFormat.Simple:
        winstonFormatters.push(winston.format.colorize(), // adds colors to the log
        winston.format.simple());
        break;
    default:
        throw new Error("Unknown log format: ".concat(logFormat, ", allowed values are: json, simple"));
}
/**
 * Since we aim to have a single API for all logs in the application, it's implemented as singleton.
 * If that turns to be insufficient, we can change that later.
 */
var winstonLogger = winston.createLogger({
    level: logLevel,
    format: (_a = winston.format).combine.apply(_a, winstonFormatters),
    transports: [new winston.transports.Console()],
});
/**
 * Singleton logger to be used across the entire application
 */
exports.logger = new logger_1.WinstonLogger(winstonLogger);
/**
 * This function will redirect all console logs and debug logs to the logger.
 *
 * The goal is to collect all logs that are not logged through the central logger and make them go through the logger.
 * That way we can control the format and destination of all logs no matter where they are logged.
 */
function redirectAllLogsToLogger() {
    (0, console_1.redirectConsoleToLogger)(exports.logger);
    (0, debug_1.redirectDebugToLogger)(exports.logger);
}
//# sourceMappingURL=logging.js.map