"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectDebugToLogger = redirectDebugToLogger;
// need to require to be able to override Debug.log, import doesn't work
var Debug = require('debug');
/**
 * This function will redirect all logs that are logged through the debug library to the logger.
 *
 * We need to route all debug logs through winston as well.
 * We have to perform a couple of tricks to make that work correctly:
 *   1. Disable colors for debug logs, otherwise the special characters for colors get printed in the log message
 *   2. Redirect the debug logs to the winston logger
 */
function redirectDebugToLogger(logger) {
    Debug.log = function (message) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var formatted = formatDebugLog.apply(void 0, __spreadArray([message], args, false));
        logger.debug(formatted.message, { args: formatted.args });
    };
}
function formatDebugLog(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    // Depending on the environment, debug might add color codes to the message and args.
    // Since we're redirecting it to a central logger, we need to get rid of those and let logger control the output format and colors.
    // Debug isn't implemented ideally and it's impossible to reliably disable colors other way than via env var DEBUG_COLORS=0
    // So, it's more reliable to remove the color codes on the fly with a regex.
    var messageWithoutColors = removeBashColors(message).trim();
    // If debug has disabled colors (only controllable via env var DEBUG_COLORS=0), it will print the date in the beginning of the message.
    // We need to remove that as well, so that the message is consistent with the rest of the logs.
    // Logger will control the output format, including if the log should contain the date.
    var finalMessage = removeDateFromStart(messageWithoutColors).trim();
    // If the debug has enabled colors, it will also add an arg to the end of args
    // that contains the duration since the previous log (i.e. "+25ms").
    // This will also contain color codes that we have to get rid of.
    if (args.length > 0 && typeof args[args.length - 1] === 'string') {
        args[args.length - 1] = removeBashColors(args[args.length - 1]);
    }
    return { message: finalMessage, args: args };
}
function removeBashColors(str) {
    return str.replace(/\u001b\[[0-9;]*m/g, '');
}
function removeDateFromStart(str) {
    return str.replace(/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/, '');
}
//# sourceMappingURL=debug.js.map