"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checksumString = checksumString;
exports.checksumMessage = checksumMessage;
var crypto_1 = require("crypto");
function checksumString(message, length) {
    if (length === void 0) { length = 50; }
    var hash = (0, crypto_1.createHash)('sha256');
    hash.update(message);
    return hash.digest('hex').substring(0, length);
}
/**
 * Do checksum of buffer or string and return the result as digest buffer.
 */
function checksumMessage(message, algorithm) {
    var hash = (0, crypto_1.createHash)(algorithm);
    hash.update(message);
    return hash.digest();
}
//# sourceMappingURL=checksum.js.map