"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForSuccessOrFailEvents = waitForSuccessOrFailEvents;
exports.waitForSuccessEventsOrFailEvent = waitForSuccessEventsOrFailEvent;
function waitForSuccessOrFailEvents(eventEmitter, successEvent, failEvent) {
    return waitForSuccessEventsOrFailEvent(eventEmitter, [successEvent], failEvent);
}
function waitForSuccessEventsOrFailEvent(eventEmitter, successEvents, failEvent) {
    return new Promise(function (resolve, reject) {
        var successListener;
        var failListener;
        successListener = function (result) {
            eventEmitter.removeListener(failEvent, failListener);
            resolve(result);
        };
        failListener = function () {
            successEvents.forEach(function (se) { return eventEmitter.removeListener(se, successListener); });
            reject(new Error('error: ' + failEvent));
        };
        successEvents.forEach(function (se) { return eventEmitter.once(se, successListener); });
        eventEmitter.once(failEvent, failListener);
    });
}
//# sourceMappingURL=eventsHelpers.js.map