"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncEventEmitter = void 0;
/**
 * Same as regular NodeJS EventEmitter, but accepts async listeners.
 */
var AsyncEventEmitter = /** @class */ (function () {
    function AsyncEventEmitter() {
        this.listeners = {};
    }
    /**
     * Adds a listener for the event. The listener will be called every time the event is emitted. The listener may be async.
     */
    AsyncEventEmitter.prototype.on = function (event, listener) {
        this.addNewListener(event, listener, false);
        return this;
    };
    /**
     * Adds a listener for the event. The listener will be called only once, the first time the event is emitted. The listener may be async.
     */
    AsyncEventEmitter.prototype.once = function (event, listener) {
        this.addNewListener(event, listener, true);
        return this;
    };
    /**
     * Removes a listener for the event.
     */
    AsyncEventEmitter.prototype.off = function (event, listener) {
        if (!this.listeners[event]) {
            return this;
        }
        this.listeners[event] = this.listeners[event].filter(function (l) { return l.listener !== listener; });
        return this;
    };
    /**
     * Alias for `on`.
     */
    AsyncEventEmitter.prototype.addListener = function (event, listener) {
        return this.on(event, listener);
    };
    /**
     * Alias for `off`.
     */
    AsyncEventEmitter.prototype.removeListener = function (event, listener) {
        return this.off(event, listener);
    };
    /**
     * Emits event and resolves, once all listeners have resolved.
     */
    AsyncEventEmitter.prototype.emit = function (event) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            var listeners;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.listeners[event]) {
                            return [2 /*return*/];
                        }
                        listeners = this.listeners[event];
                        // Remove all listeners that should be called only once
                        this.listeners[event] = listeners.filter(function (_a) {
                            var once = _a.once;
                            return !once;
                        });
                        return [4 /*yield*/, Promise.all(listeners.map(function (_a) {
                                var listener = _a.listener;
                                return listener.apply(void 0, args);
                            }))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    AsyncEventEmitter.prototype.addNewListener = function (event, listener, once) {
        if (!this.listeners[event]) {
            this.listeners[event] = [];
        }
        this.listeners[event].push({ listener: listener, once: once });
    };
    return AsyncEventEmitter;
}());
exports.AsyncEventEmitter = AsyncEventEmitter;
//# sourceMappingURL=AsyncEventEmitter.js.map