"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeoutError = exports.waitUntil = void 0;
exports.waitUntilNotNull = waitUntilNotNull;
var timeout_ts_1 = __importDefault(require("timeout-ts"));
/**
 * Repeatedly calls predicate until it returns a truthy value.
 * @returns the first truthy value returned by predicate
 */
var waitUntil = function (predicate_1) {
    var args_1 = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args_1[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, __spreadArray([predicate_1], args_1, true), void 0, function (predicate, interval) {
        var result;
        if (interval === void 0) { interval = 100; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!true) return [3 /*break*/, 3];
                    return [4 /*yield*/, predicate()];
                case 1:
                    result = _a.sent();
                    if (result) {
                        return [2 /*return*/, result];
                    }
                    return [4 /*yield*/, (0, timeout_ts_1.default)(interval)];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 0];
                case 3: return [2 /*return*/];
            }
        });
    });
};
exports.waitUntil = waitUntil;
/**
 * Repeatedly calls resultCallback until it returns a non-null value.
 * @throws TimeoutError if resultCallback does not return a non-null value within the specified timeoutMs
 * @returns the first non-null value returned by resultCallback
 */
function waitUntilNotNull(resultCallback_1) {
    return __awaiter(this, arguments, void 0, function (resultCallback, options) {
        var startTime, result;
        var _a, _b;
        if (options === void 0) { options = {}; }
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    // Default options
                    options.intervalMs = (_a = options.intervalMs) !== null && _a !== void 0 ? _a : 1e3;
                    options.timeoutMs = (_b = options.timeoutMs) !== null && _b !== void 0 ? _b : 30e3;
                    startTime = new Date().valueOf();
                    _c.label = 1;
                case 1:
                    if (!(startTime + options.timeoutMs > new Date().valueOf())) return [3 /*break*/, 6];
                    return [4 /*yield*/, resultCallback()];
                case 2:
                    result = _c.sent();
                    if (!(result === null)) return [3 /*break*/, 4];
                    return [4 /*yield*/, (0, timeout_ts_1.default)(options.intervalMs)];
                case 3:
                    _c.sent();
                    return [3 /*break*/, 5];
                case 4: return [2 /*return*/, result];
                case 5: return [3 /*break*/, 1];
                case 6: throw new TimeoutError(options.timeoutMs);
            }
        });
    });
}
var TimeoutError = /** @class */ (function (_super) {
    __extends(TimeoutError, _super);
    function TimeoutError(timeoutMs) {
        var _this = _super.call(this, "Wait until has timed-out after ".concat(timeoutMs, " ms")) || this;
        _this.timeoutMs = timeoutMs;
        return _this;
    }
    return TimeoutError;
}(Error));
exports.TimeoutError = TimeoutError;
/** @deprecated use named import instead */
exports.default = exports.waitUntil;
//# sourceMappingURL=waitUntil.js.map