import IAction from '../IAction';
export declare const SocketConnected = "Web.Socket.Connected";
export interface SocketConnected extends IAction<typeof SocketConnected> {
}
export declare const SocketDisconnected = "Web.Socket.Disconnected";
export interface SocketDisconnected extends IAction<typeof SocketDisconnected> {
}
export declare const PlatformConnect = "Web.Socket.PlatformConnect";
export interface PlatformConnect extends IAction<typeof PlatformConnect> {
    platformUri: string;
    driver: string;
    checkTimeBeforeConnection: boolean;
}
/**
 * The type of socket which is connecting from different part of application
 * "front" is connecting from applet browser
 * "management" is connecting from Node.js and on some platform is same as "front" in browser, but it's for different purposes
 * "service" is connecting from Android devices from the native app written in Kotlin
 */
type SocketName = 'front' | 'management' | 'service';
export declare const DeviceServerConnected = "Socket.DeviceServerConnected";
export interface DeviceServerConnected extends IAction<typeof DeviceServerConnected> {
    deviceUid: string;
    serverInstanceUid: string;
    socketUid: string;
    socketName: SocketName;
}
export declare const DeviceServerDisconnected = "Socket.DeviceServerDisconnected";
export interface DeviceServerDisconnected extends IAction<typeof DeviceServerDisconnected> {
    deviceUid: string;
    serverInstanceUid: string;
    socketUid: string;
    socketName: SocketName;
}
export {};
