import IAction from '../IAction';
import RegisterFailReason from './RegisterFailReason';
import ApplicationType from "../Application/ApplicationType";
export declare const RegisterDevice = "Device.RegisterDevice";
export interface RegisterDevice extends IAction<typeof RegisterDevice> {
    uid: string;
    applicationType: ApplicationType;
    autoVerification?: {
        organizationUid: string;
        deviceName?: string;
    };
}
export declare const DeviceRegistrationSucceeded = "Device.DeviceRegistrationSucceed";
export interface DeviceRegistrationSucceeded extends IAction<typeof DeviceRegistrationSucceeded> {
}
export declare const DeviceRegistrationFailed = "Device.DeviceRegistrationFailed";
export interface DeviceRegistrationFailed extends IAction<typeof DeviceRegistrationFailed> {
    reason: RegisterFailReason;
}
export declare const UpdateDeviceName = "Device.UpdateDevice";
export interface UpdateDeviceName extends IAction<typeof UpdateDeviceName> {
    deviceName: string;
}
/** @deprecated */
export declare const UpdateDeviceModel = "Device.UpdateDeviceModel";
/** @deprecated */
export interface UpdateDeviceModel extends IAction<typeof UpdateDeviceModel> {
    deviceModel: string;
}
export declare const UpdateDeviceInfo = "Device.UpdateDeviceInfo";
export interface UpdateDeviceInfo extends IAction<typeof UpdateDeviceInfo> {
    applicationType?: string;
    model?: string;
    serialNumber?: string;
    brand?: string;
    osVersion?: string;
    ethernetMacAddress?: string;
    wifiMacAddress?: string;
    wifiStrength?: number;
    wifiSsid?: string;
    activeInterface?: 'wifi' | 'ethernet';
    ipAddress?: string;
    netmask?: string;
    gateway?: string;
    domainNameServers?: string[];
    interfaceName?: string;
    proxy?: {
        enabled: boolean;
        uri: string;
    };
    specs?: ISpecs;
}
export type ISpecs = IAndroidSpecs;
/**
 * Android specific device info specs
 * Example values in comments
 */
export interface IAndroidSpecs {
    build: {
        version: {
            release: string;
            sdk: number;
            codename: string;
        };
        product: {
            brand: string;
            model: string;
            supportedAbis: string[];
            manufacturer?: string;
            device?: string;
            board?: string;
        };
    };
    signatures: {
        /** Platform signature. */
        framework: {
            sha256: string;
        };
        /** Management app signature. */
        application?: {
            sha256: string;
        };
    };
}
