import IAction from '../../IAction';
import Resolution from './Resolution';
import ResolutionList, { ResolutionItem } from './ResolutionList';
import Orientation from './Orientation';
import VideoOrientation from './VideoOrientation';
export type DeviceResizeType = 'Device.Resolution.ResizeDevice';
export declare const DeviceResize: DeviceResizeType;
export interface DeviceResize extends IAction<DeviceResizeType> {
    uid: string;
    /**
     * @deprecated this enumerated value was replaced by screenSize to provide possibility of setting certain width, height
     * values because some devices can support many resolutions and adding many enumerated values seems to be inpractical
     */
    screenResolution: Resolution;
    screenSize: ResolutionItem;
    screenOrientation: Orientation;
    videoOrientation?: VideoOrientation;
}
export type DeviceResizeSucceededType = 'Device.Resolution.DeviceResizeSucceeded';
export declare const DeviceResizeSucceeded: DeviceResizeSucceededType;
export interface DeviceResizeSucceeded extends IAction<DeviceResizeSucceededType> {
    uid: string;
}
export type DeviceResizeFailedType = 'Device.Resolution.DeviceResizeFailed';
export declare const DeviceResizeFailed: DeviceResizeFailedType;
export interface DeviceResizeFailed extends IAction<DeviceResizeFailedType> {
    uid: string;
}
export type NotifySupportedResolutionsType = 'Device.Resolution.NotifySupportedResolutions';
export declare const NotifySupportedResolutions: NotifySupportedResolutionsType;
export interface NotifySupportedResolutions extends IAction<NotifySupportedResolutionsType> {
    supportedResolutions: ResolutionList;
}
