/**
 * This action is to enable/disable the remote desktop for specific server URL.
 */
export declare const SetRemoteDesktopSettings = "RemoteDesktop.SetRemoteDesktopSettings";
export type SetRemoteDesktopSettings = (SetRemoteDesktopSettingsEnabled | SetRemoteDesktopSettingsDisabled) & {
    type: typeof SetRemoteDesktopSettings;
    uid: string;
    enabled: boolean;
};
interface SetRemoteDesktopSettingsDisabled {
    enabled: false;
}
interface SetRemoteDesktopSettingsEnabled {
    enabled: true;
    /** Base url to the remote-desktop service that makes an operator between device and browser */
    serverUrl: string;
    /** The frequency of refreshing remote desktop screen on the browser side */
    frequencyMs?: number;
}
export declare const SetRemoteDesktopSettingsSucceeded = "RemoteDesktop.SetRemoteDesktopSettingsSucceeded";
export interface SetRemoteDesktopSettingsSucceeded {
    type: typeof SetRemoteDesktopSettingsSucceeded;
    uid: string;
}
export declare const SetRemoteDesktopSettingsFailed = "RemoteDesktop.SetRemoteDesktopSettingsFailed";
export interface SetRemoteDesktopSettingsFailed {
    type: typeof SetRemoteDesktopSettingsFailed;
    uid: string;
}
export {};
