import IAction from '../../IAction';
export type SetDevicePeerRecoveryType = 'Device.PeerRecovery.SetPeerRecovery';
export declare const SetDevicePeerRecovery: SetDevicePeerRecoveryType;
export type SetDevicePeerRecovery = IAction<SetDevicePeerRecoveryType> & (SetDevicePeerRecoveryEnabled | SetDevicePeerRecoveryDisabled);
type SetDevicePeerRecoveryEnabled = {
    uid: string;
    enabled: true;
    /**
     * This URL address has to be set in URL launcher on device that is recovered.
     */
    urlLauncherAddress: string;
};
type SetDevicePeerRecoveryDisabled = {
    uid: string;
    enabled: false;
    /**
     * When specified it defines period until automatic enabling peer recovery process in miliseconds.
     */
    autoEnableTimeoutMs?: number;
};
export type SetDevicePeerRecoverySucceededType = 'Device.PeerRecovery.SetPeerRecoverySucceeded';
export declare const SetDevicePeerRecoverySucceeded: SetDevicePeerRecoverySucceededType;
export interface SetDevicePeerRecoverySucceeded extends IAction<SetDevicePeerRecoverySucceededType> {
    uid: string;
}
export type SetDevicePeerRecoveryFailedType = 'Device.PeerRecovery.SetPeerRecoveryFailed';
export declare const SetDevicePeerRecoveryFailed: SetDevicePeerRecoveryFailedType;
export interface SetDevicePeerRecoveryFailed extends IAction<SetDevicePeerRecoveryFailedType> {
    uid: string;
}
export {};
