"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteCustomScriptFailed = exports.ExecuteCustomScriptSucceeded = exports.ExecuteCustomScript = void 0;
/**
 * Executes a custom script on the device.
 */
exports.ExecuteCustomScript = 'Device.CustomScript.ExecuteCustomScript';
/**
 * Reports the success of executing a custom script on the device.
 * The script itself could fail internally and that is based on internal logic of a specific runtime (i.e. PowerShell & Bash uses exitCode).
 * So the success of this action means that the script was successfully delivered to the device and executed.
 */
exports.ExecuteCustomScriptSucceeded = 'Device.CustomScript.ExecuteCustomScriptSucceeded';
/**
 * Reports the failure during delivering or an unexpected error during executing a custom script on the device.
 */
exports.ExecuteCustomScriptFailed = 'Device.CustomScript.ExecuteCustomScriptFailed';
//# sourceMappingURL=deviceCustomScriptActions.js.map