import IAction from '../../IAction';
export declare const SetDeviceAutoRecovery = "Device.AutoRecovery.SetAutoRecovery";
export type SetDeviceAutoRecoveryType = typeof SetDeviceAutoRecovery;
export type SetDeviceAutoRecovery = IAction<SetDeviceAutoRecoveryType> & (SetDeviceAutoRecoveryEnabled | SetDeviceAutoRecoveryDisabled);
type SetDeviceAutoRecoveryEnabled = {
    uid: string;
    enabled: true;
    /**
     * It defines in miliseconds period whose elapsing leads to mark browser process as unresponding.
     */
    healthcheckIntervalMs: number;
};
type SetDeviceAutoRecoveryDisabled = {
    uid: string;
    enabled: false;
    /**
     * When specified it defines period until automatic enabling auto recovery process in miliseconds.
     */
    autoEnableTimeoutMs?: number;
};
export declare const SetDeviceAutoRecoverySucceeded = "Device.AutoRecovery.SetAutoRecoverySucceeded";
export type SetDeviceAutoRecoverySucceededType = typeof SetDeviceAutoRecoverySucceeded;
export interface SetDeviceAutoRecoverySucceeded extends IAction<SetDeviceAutoRecoverySucceededType> {
    uid: string;
}
export declare const SetDeviceAutoRecoveryFailed = "Device.AutoRecovery.SetAutoRecoveryFailed";
export type SetDeviceAutoRecoveryFailedType = typeof SetDeviceAutoRecoveryFailed;
export interface SetDeviceAutoRecoveryFailed extends IAction<SetDeviceAutoRecoveryFailedType> {
    uid: string;
}
export {};
