import IAction from '../IAction';
export declare const SubscribeActiveApplet = "Applet.SubscribeActiveApplet";
export interface SubscribeActiveApplet extends IAction<typeof SubscribeActiveApplet> {
    deviceUid: string;
}
export declare const UpdateActiveAppletBinary = "Applet.UpdateActiveAppletBinary";
export interface UpdateActiveAppletBinary extends IAction<typeof UpdateActiveAppletBinary> {
    activeAppletUid: string;
    activeConfiguration: any;
    activeTimingChecksum: string;
    activeAppletVersion: string;
    /** Optional, because of backward compatibility. Packages came later */
    activeAppletIsPackage?: boolean;
    activeAppletVersionPostfix?: string;
    activeAppletHugApiVersion?: string;
    activeAppletFrontAppletVersion?: string;
    activeAppletMetadata?: {
        encryptedConfig?: Record<string, string>;
    };
}
export declare const LastActiveAppletMissed = "Applet.LastActiveAppletMissed";
export interface LastActiveAppletMissed extends IAction<typeof LastActiveAppletMissed> {
}
export declare const UpdateActiveAppletUniqueHash = "Applet.UpdateActiveAppletUniqueHash";
export interface UpdateActiveAppletUniqueHash extends IAction<typeof UpdateActiveAppletUniqueHash> {
    hash: string;
}
export declare const UpdateActiveAppletSavedFiles = "Applet.UpdateActiveAppletSavedFiles";
export interface UpdateActiveAppletSavedFiles extends IAction<typeof UpdateActiveAppletSavedFiles> {
    savedFiles: {
        [uid: string]: {
            filePath: string;
        };
    };
}
export declare const UpdateActiveAppletSavedContents = "Applet.UpdateActiveAppletSavedContents";
export interface UpdateActiveAppletSavedContents extends IAction<typeof UpdateActiveAppletSavedContents> {
    savedContents: {
        [uid: string]: string;
    };
}
export declare const SetupAppletIframeId = "Applet.SetupAppletIframeId";
export interface SetupAppletIframeId extends IAction<typeof SetupAppletIframeId> {
    id: string;
}
export declare const UpdateActiveAppletBinaryFile = "Applet.UpdateActiveAppletBinaryFile";
export interface UpdateActiveAppletBinaryFile extends IAction<typeof UpdateActiveAppletBinaryFile> {
    appletBinaryFile: {
        localUri: string;
    } | null;
    appletFrontAppletJsFile: {
        localUri: string;
    } | null;
}
export interface IAppletTimingDefinition {
    appletUid: string;
    configuration: any;
    timmingChecksum: string;
    appletVersion: string;
    /** Optional, because of backward compatibility. Packages came later */
    isPackage?: boolean;
    appletVersionPostfix?: string;
    frontAppletVersion?: string;
    finishEvent: {
        type: string;
        data?: any;
    };
    position: number;
    metadata?: {
        encryptedConfig?: Record<string, string>;
    };
}
export declare const UpdateAppletTimingsDefinition = "Applet.UpdateAppletTimingsDefinition";
export interface UpdateAppletTimingsDefinition extends IAction<typeof UpdateAppletTimingsDefinition> {
    definitions: IAppletTimingDefinition[];
}
