import IAction from '../IAction';
export declare const ActiveAppletDispatchCommand = "Applet.ActiveAppletDispatchCommand";
export interface ActiveAppletDispatchCommand extends IAction<typeof ActiveAppletDispatchCommand> {
    appletUid: string;
    timingChecksum: string;
    command: any;
}
export declare const AppletPing = "Applet.ActiveAppletPing";
export interface AppletPing extends IAction<typeof AppletPing> {
    appletUid: string;
    timingChecksum: string;
}
export declare const DispatchCommandToApplet = "Applet.DispatchCommandToApplet";
export interface DispatchCommandToApplet extends IAction<typeof DispatchCommandToApplet> {
    appletUid: string;
    command: any;
}
export declare const ActiveAppletStreamPlay = "Applet.ActiveAppletStreamPlay";
export interface ActiveAppletStreamPlay extends IAction<typeof ActiveAppletStreamPlay> {
    appletUid: string;
    timingChecksum: string;
    data: {
        uri: string;
        x: number;
        y: number;
        width: number;
        height: number;
    };
}
export declare const ActiveAppletStreamStop = "Applet.ActiveAppletStreamStop";
export interface ActiveAppletStreamStop extends IAction<typeof ActiveAppletStreamStop> {
    appletUid: string;
    timingChecksum: string;
    data: {
        uri: string;
        x: number;
        y: number;
        width: number;
        height: number;
    };
}
export declare const ActiveAppletLoaded = "Applet.ActiveAppletLoaded";
export interface ActiveAppletLoaded extends IAction<typeof ActiveAppletLoaded> {
    appletUid: string;
    timingChecksum: string;
}
export declare const ActiveAppletReady = "Applet.ActiveAppletReady";
export interface ActiveAppletReady extends IAction<typeof ActiveAppletReady> {
    appletUid: string;
    timingChecksum: string;
}
export declare const ActiveAppletRestore = "Applet.ActiveAppletRestore";
export interface ActiveAppletRestore extends IAction<typeof ActiveAppletRestore> {
    appletUid: string;
    timingChecksum: string;
}
export declare const ActiveOpenBrowserLink = "Applet.ActiveOpenBrowserLink";
export interface ActiveOpenBrowserLink extends IAction<typeof ActiveOpenBrowserLink> {
    appletUid: string;
    timingChecksum: string;
    uri: string;
}
