function Invoke-PSMinVersionCheck {
	param(
		[Parameter(Mandatory = $true)]
		[version]
		$minPSVersion
	)

	$currentPSVersion = Get-PSVersion;
	$isCurrentPSVersionValid = $currentPSVersion -ge $minPSVersion
	if (-not $isCurrentPSVersionValid) {
		$currentPSVersionString = $currentPSVersion.toString()
		throw "PowerShell $currentPSVersionString isn't suported. Upgrade to $minPSVersion or higher."
	}
}

function Get-PSVersion {
	return $PSVersionTable.PSVersion;
}
