param (
	[Parameter(Mandatory = $true, Position = 0)]
	[ValidateNotNullOrEmpty()]
	[ValidateSet('install', 'uninstall')]
	[string]
	$Setup
)

$ErrorActionPreference = 'Stop'

Write-Host "# Reading configuration #"
.\4-Powershell\Read-ConfigurationFile.ps1

Write-Host "# Setting environment #"
.\4-Powershell\Set-Environment.ps1

$Steps = $Steps | Where-Object { $null -ne $_."$Setup" }

if ($null -eq $Steps) {
	Write-Host "Installation steps not found!"
	exit
}

if ($Setup -eq 'uninstall') {
	[array]::Reverse($Steps)
}

try {
	$LASTEXITCODE = 0
	$Steps | ForEach-Object {
		$Step = $_."$Setup"
		if (-not $_.InstallerOnly) {
			try {
				Write-Host "Running step: $($Step.name)"
				$Output = Invoke-Expression -Command $Step.scriptFile
				if ($LASTEXITCODE -ne 0) {
					throw "$($Output | Out-String)"
				}
			} catch {
				if ($Setup -eq 'install') {
					throw $_
				} else {
					Write-Host $_ -ForegroundColor Red
				}
			}
		}
	}
} finally {
	Write-Host "# Cleaning up #"
	.\4-Powershell\Clear-Environment.ps1
}
