
function New-ServiceWrapper(
    [string] $NewExecutablePath,
    [string] $WinSWExecutablePath
) {
    Copy-Item `
        -Path $WinSWExecutablePath `
        -Destination $NewExecutablePath `
        -Force
}

function Start-ServiceWrapper([string] $WrapperPath) {
    .$WrapperPath start
}

function Stop-ServiceWrapper([string] $WrapperPath) {
    .$WrapperPath stop
}

function Install-ServiceWrapper([string] $WrapperPath) {
    .$WrapperPath install
}

function Uninstall-ServiceWrapper([string] $WrapperPath) {
    .$WrapperPath uninstall
}

Export-ModuleMember -Function New-ServiceWrapper, Start-ServiceWrapper, Stop-ServiceWrapper, Install-ServiceWrapper, Uninstall-ServiceWrapper
