Import-Module $PSScriptRoot\ServiceConfig.psm1 -Force
Import-Module $PSScriptRoot\ServiceWrapper.psm1 -Force

function Install-KioskService(
    [string] $ServiceName,
    [string] $ServiceExecutableFilePath,
    [string] $ServiceDescription,
    [object[]] $ServiceEnvironmentalVariables,
    [string] $WinSWExecutablePath,
    [string] $ServiceWrapperFolderPath,
    [string] $NodeExecutablePath,
    [string] $ServiceWorkingDirectory
) {
  $ServiceId = Get-ServiceId $ServiceName
  $ServiceConfigName = $ServiceId + ".xml"
  $ServiceWrapperName = $ServiceId + ".exe"
  $ServiceConfigPath = Join-Path $ServiceWrapperFolderPath $ServiceConfigName
  $ServiceWrapperExecutablePath = Join-Path $ServiceWrapperFolderPath $ServiceWrapperName

  $serviceConfig = New-NodeServiceConfig `
    -Id $ServiceId `
    -Name $ServiceName `
    -Description $ServiceDescription `
    -NodeExecutablePath $NodeExecutablePath `
    -MaxAvailableMemory 4096 `
    -ServiceExecutableFilePath $ServiceExecutableFilePath

  $serviceConfig.SetLogModeRollBySizeTime(
      "yyyyMMdd",
      "00:00:00",
      "10240",
      14
  )
  $serviceConfig.SetStopTimeout("30sec")

  Foreach ($Variable in $ServiceEnvironmentalVariables) {
      $serviceConfig.SetEnvironmentalVariable($Variable.Name, $Variable.Value)
  }

  try {
    $organizationUid = Get-Content -Path "organizationUid.txt" -ErrorAction Stop
} catch {
    $organizationUid = $null
}

if (![string]::IsNullOrWhiteSpace($organizationUid)) {
    $serviceConfig.SetEnvironmentalVariable("organizationUid", $organizationUid)
}

  $serviceConfig.SetOnFailure("restart", "5 sec")
  $serviceConfig.SetOnFailure("restart", "15 sec")
  $serviceConfig.SetOnFailure("restart", "60 sec")

  $serviceConfig.SetWorkingDirectory($ServiceWorkingDirectory)

  $serviceConfig.SetDependency("winmgmt")

  $serviceConfig.Save($ServiceConfigPath)

  New-ServiceWrapper `
    -NewExecutablePath $ServiceWrapperExecutablePath `
    -WinSWExecutablePath $WinSWExecutablePath

  Uninstall-ServiceWrapper -WrapperPath $ServiceWrapperExecutablePath
  Install-ServiceWrapper -WrapperPath $ServiceWrapperExecutablePath
  Start-ServiceWrapper -WrapperPath $ServiceWrapperExecutablePath
}

Export-ModuleMember -Function Install-KioskService
