
Import-Module $PSScriptRoot\AutoAdminLogon\AutoAdminLogon.psm1 -Force
Import-Module $PSScriptRoot\LogOffUser\LogOffUser.psm1 -Force

$username = $env:KioskUsername

Invoke-LogOffuser -Username $username

$user = Get-LocalUser | Where-Object { $_.Name -eq $username }
$userCimInstances = Get-CimInstance -Class Win32_UserProfile | Where-Object { $_.LocalPath.split('\')[-1] -eq $username }

if ($user) {
  Write-Host "Removing $username user profile"
  $userCimInstances | ForEach { Remove-CimInstance -InputObject $_ }

  Write-Host "Removing local user: $username"
  Remove-LocalUser -Name $username

  Clear-AutoAdminLogon

  Write-Host "User: $username has been completely removed."
} else {
  Write-Warning "User $username not found."
}
