
function Invoke-LogOffuser([string] $Username) {
    if ($username -match ' ') {
        throw "Usernames including whitespaces are not supported"
    }

    $sessionId = ((quser | Where-Object { $_ -match $Username }) -split ' +')[2]
    if ($sessionId) {
        LogOff $sessionId
        Write-Host "User $Username logged off." 
    }
}
