
$ErrorActionPreference = "Stop"

Import-Module $PSScriptRoot\Service\InstallKioskService.psm1 -Force

$KioskServerBinaryRootPath = Join-Path $env:ContentRootFolder $env:KioskServerBinaryRootPath
$NodeExecutablePath = Join-Path $env:ContentRootFolder $env:NodeExecutablePath
$WinSWExecutablePath = Join-Path $PSScriptRoot\.. $env:WinSWExecutablePath

$ServiceWrapperFolderPath = Join-Path $KioskServerBinaryRootPath "daemon"
$ServiceExecutableFilePath = Join-Path $KioskServerBinaryRootPath "server.js"
$ServiceEnvironmentalVariables = @(
  @{Name="ISOMORPHIC_TARGET";Value="node"};
  @{Name="DATADIR";Value=$KioskServerBinaryRootPath};
  @{Name="PORT";Value=3000};
  @{Name="COMPORT";Value=$env:SerialPort};
)

Install-KioskService `
  -ServiceName $env:ServiceName `
  -ServiceDescription $env:ServiceDescription `
  -ServiceExecutableFilePath $ServiceExecutableFilePath `
  -ServiceEnvironmentalVariables $ServiceEnvironmentalVariables `
  -ServiceWorkingDirectory $KioskServerBinaryRootPath `
  -ServiceWrapperFolderPath $ServiceWrapperFolderPath `
  -NodeExecutablePath $NodeExecutablePath `
  -WinSWExecutablePath $WinSWExecutablePath

$ScreenshotServiceWrapperFolderPath = Join-Path `
  $KioskServerBinaryRootPath `
  "dist\screenshotServer\daemon"
$ScreenshotServiceExecutableFilePath = Join-Path `
  $KioskServerBinaryRootPath `
  "dist\screenshotServer\screenshotServer.js"
$ScreenshotServiceEnvironmentalVariables = @(
  @{Name="DATADIR";Value=$KioskServerBinaryRootPath};
)

Install-KioskService `
  -ServiceName $env:ScreenshotServiceName `
  -ServiceDescription $env:ScreenshotServiceDescription `
  -ServiceExecutableFilePath $ScreenshotServiceExecutableFilePath `
  -ServiceEnvironmentalVariables $ScreenshotServiceEnvironmentalVariables `
  -ServiceWorkingDirectory $KioskServerBinaryRootPath `
  -ServiceWrapperFolderPath $ScreenshotServiceWrapperFolderPath `
  -NodeExecutablePath $NodeExecutablePath `
  -WinSWExecutablePath $WinSWExecutablePath
