
.$PSScriptRoot\New-LogsDirectory.ps1

Write-Host "Setup NodeJS"
$deploymentNodePath = ".\1-Executables\node\x64\node.exe"
$installNodePath = Join-Path $env:ContentRootFolder $env:NodeExecutablePath
New-Item -Path $installNodePath -Force | Out-Null
Copy-Item -Path $deploymentNodePath -Destination $installNodePath -Force

Write-Host "Setup 7Zip"
$deployment7ZipDirPath = Resolve-Path -Path ".\1-Executables\7Zip\x64"
$install7ZipDirPath = Join-Path $env:ContentRootFolder $env:7ZipExecutableDirPath
New-Item -Path $install7ZipDirPath -ItemType Directory -Force | Out-Null
Copy-Item -Path "$deployment7ZipDirPath\*" -Destination $install7ZipDirPath -Recurse -Force

Write-Host "Setup TimeZoneConverter"
$7ZipPath = Resolve-Path -Path ".\1-Executables\7Zip\x64\7z.exe"
$sourcePath = Resolve-Path -Path ".\1-Executables\timezoneconverter\timezoneconverter.nupkg"
$destinationPath = "C:\signageos\Packages\TimeZoneConverter.3.2.0\"
$fileName = "lib\net45\TimeZoneConverter.dll"
& $7ZipPath x $sourcePath -o"$destinationPath" -r -y $fileName | Out-Null

Write-Host "Setup Remote Desktop Service"
$7ZipPath = Resolve-Path -Path ".\1-Executables\7Zip\x64\7z.exe"
$sourcePath = Resolve-Path -Path ".\1-Executables\rd\1.0.0.zip"
$destinationPath = "C:\signageos\Packages\rd"
& $7ZipPath x $sourcePath -o"$destinationPath" -r -y | Out-Null