
function Remove-ScheduledTask {
  Param(
    [Parameter(Mandatory = $true)]
    [string]
    $TaskName
  )

  if ($(Get-ScheduledTask -TaskName $TaskName -ErrorAction SilentlyContinue).TaskName -eq $TaskName) {
    Unregister-ScheduledTask -TaskName $TaskName -Confirm:$False
  } else {
    Write-Warning "Scheduled task '$TaskName' not found."
  }
}
