
function Clear-Environment([PSCustomObject] $Config) {
	if ($null -eq $Config) {
		throw 'Missing configuration'
	}

	$Config.PSObject.Properties | ForEach-Object {
		Write-Debug "Setting environment variable `"$($_.Name)`" to `"$($_.Value)`""

		$path = "env:$($_.Name)"
		$pathExists = Test-Path $path
		if ($pathExists) {
			Clear-Item -Path $path
			[System.Environment]::SetEnvironmentVariable("$path", $null, [System.EnvironmentVariableTarget]::User)
		}
	}
}

Clear-Environment -Config $Config
