
Import-Module $PSScriptRoot\..\Get-PlainTextFromSecureString.psm1 -Force

$registry = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"

function Set-AutoAdminLogon {
  param (
    [Parameter(Mandatory=$true)]
    [string]
    $Username,

    [Parameter(Mandatory=$true)]
    [Security.SecureString]
    $Password
  )

  Set-ItemProperty $registry -Name AutoAdminLogon -Value 1
  Set-ItemProperty $registry -Name DefaultUserName -Value "$Username"
  $PlainTextPassword = Get-PlainTextFromSecureString -SecureString $Password
  Set-ItemProperty $registry -Name DefaultPassword -Value "$PlainTextPassword"
}

function Clear-AutoAdminLogon {  
  Set-ItemProperty $registry -Name AutoAdminLogon -Value 0
  Set-ItemProperty $registry -Name DefaultUserName -Value ""
  Set-ItemProperty $registry -Name DefaultPassword -Value ""
}
